﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace IndianHealthService.BMXNet.Util
{
    /// <summary>
    /// Convienence class to provide information from the AssembleInfo
    /// <code>
    /// [assembly: AssemblyTitle("IndianHealthService.BMXNet.Test")]
    /// [assembly: AssemblyDescription("A test application")]
    /// [assembly: AssemblyCompany("IHS")]
    /// [assembly: AssemblyProduct("IndianHealthService.BMXNet.Test")]
    /// [assembly: AssemblyCopyright("IHS 2009")]
    /// [assembly: AssemblyVersion("2.0.0.0")]    
    /// </code>
    /// </summary>
    public static class EntryAssemblyInfo
    {
        /// <summary>
        /// Convienence method to provide information from the AssembleInfo
        /// <code>
        /// [assembly: AssemblyTitle("IndianHealthService.BMXNet.Test")]
        /// </code>
        /// </summary>
        public static string AssemblyTitle
        {
            get
            {
                // Get all Title attributes on this assembly
                object[] attributes = Assembly.GetEntryAssembly().GetCustomAttributes(typeof(AssemblyTitleAttribute), false);
                // If there is at least one Title attribute
                if (attributes.Length > 0)
                {
                    // Select the first one
                    AssemblyTitleAttribute titleAttribute = (AssemblyTitleAttribute)attributes[0];
                    // If it is not an empty string, return it
                    if (titleAttribute.Title != "")
                        return titleAttribute.Title;
                }
                // If there was no Title attribute, or if the Title attribute was the empty string, return the .exe name
                return System.IO.Path.GetFileNameWithoutExtension(Assembly.GetExecutingAssembly().CodeBase);
            }
        }

    /// <summary>
    /// Convienence method to provide information from the AssembleInfo
    /// <code>
    /// [assembly: AssemblyVersion("2.0.0.0")]    
    /// </code> 
    /// </summary>
    public static string AssemblyVersion
        {
            get
            {
                return Assembly.GetEntryAssembly().GetName().Version.ToString();
            }
        }

    /// <summary>
    /// Convienence method to provide information from the AssembleInfo
    /// <code>
    /// [assembly: AssemblyDescription("A test application")]
    /// </code> 
    /// </summary>
    public static string AssemblyDescription
        {
            get
            {
                // Get all Description attributes on this assembly
                object[] attributes = Assembly.GetEntryAssembly().GetCustomAttributes(typeof(AssemblyDescriptionAttribute), false);
                // If there aren't any Description attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Description attribute, return its value
                return ((AssemblyDescriptionAttribute)attributes[0]).Description;
            }
        }

    /// <summary>
    /// Convienence method to provide information from the AssembleInfo
    /// <code>
    /// [assembly: AssemblyProduct("IndianHealthService.BMXNet.Test")]
    /// </code> 
    /// </summary>
    public static string AssemblyProduct
        {
            get
            {
                // Get all Product attributes on this assembly
                object[] attributes = Assembly.GetEntryAssembly().GetCustomAttributes(typeof(AssemblyProductAttribute), false);
                // If there aren't any Product attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Product attribute, return its value
                return ((AssemblyProductAttribute)attributes[0]).Product;
            }
        }

    /// <summary>
    /// Convienence method to provide information from the AssembleInfo
    /// <code>
    /// [assembly: AssemblyCopyright("IHS 2009")]
    /// </code> 
    /// </summary>
    public static string AssemblyCopyright
        {
            get
            {
                // Get all Copyright attributes on this assembly
                object[] attributes = Assembly.GetEntryAssembly().GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
                // If there aren't any Copyright attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Copyright attribute, return its value
                return ((AssemblyCopyrightAttribute)attributes[0]).Copyright;
            }
        }

    /// <summary>
    /// Convienence method to provide information from the AssembleInfo
    /// <code>
    /// [assembly: AssemblyCompany("IHS")]
    /// </code> 
    /// </summary>
    public static string AssemblyCompany
        {
            get
            {
                // Get all Company attributes on this assembly
                object[] attributes = Assembly.GetEntryAssembly().GetCustomAttributes(typeof(AssemblyCompanyAttribute), false);
                // If there aren't any Company attributes, return an empty string
                if (attributes.Length == 0)
                    return "";
                // If there is a Company attribute, return its value
                return ((AssemblyCompanyAttribute)attributes[0]).Company;
            }
        }
 
    }
}
